


#ifndef __FLASHSPI_MG04_06_H

#define __FLASHSPI_MG04_06_H

/**
 ******************************************************************************
 *
 * @file        Flash_MG04_06.h
 * @brief       Use SPI module to control FLASH (MX25R6435F).
 
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2022/08/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#include "MG32x02z_SPI_DRV.h"
#include "BSP_Common_MG04_06.h"


/** 
 * @name  Define 
 */                                                      
///@{


/*GPIO */
#define FLASH_CEN               PD0 
#define FLASH_CEN_IOM           PIND(0)
#define FLASH_CEN_AFS           0

#define FLASH_SCK_IOM           PIND(1)
#define FLASH_SCK_AFS           7 
  
#define FLASH_D0_IOM            PIND(2)
#define FLASH_D0_AFS            7

#define FLASH_D1_IOM            PIND(7)
#define FLASH_D1_AFS            5 
 
/*Signal order*/

#define FLASH_CEN_NOACTIVE          1
#define FLASH_CEN_ACTIVE            0


/*Flash ID*/
#define FLASH_RDID                  0xC21728      /*!< Manufacturer ID + Memory type + Memory density */
#define FLASH_RES                   0x10          /*!< Electronic ID                                  */
#define FLASH_REMS                  0xC210        /*!< Manufacturer ID + Device ID                    */


/*Flash Size*/
#define FLASH_MAXSIZE               64 * 1024     /*!< Flash Total Size */
#define FLASH_PROGRAM_MAX           256           /*!< Define Flash program max bytes  in one write enable.   */ 

/*Flash Command*/

#define FLASH_NORMAL_READ           0x03          /*!< Read data bytes                                        */
#define FLASH_FAST_READ             0x0B          /*!< Read data bytes at higher speed                        */
                                                  
#define FLASH_2IO_READ              0xBB          /*!< 2 x I/O read mode                                      */
#define FLASH_1I_2O_READ            0x3B          /*!< Dual read mode                                         */
#define FLASH_4IO_READ              0xEB          /*!< 4 x I/O read mode                                      */
#define FLASH_1I_4O_Read            0x6B          /*!< Quad read mode                                         */
                                                  
#define FLASH_PAGE_PROGRAM          0x02          /*!< Page program                                           */
#define FLASH_QUADPAGE_PROGRAM      0x38          /*!< 4 x I/O page program                                   */
                                                  
#define FLASH_SFDP_READ             0x5A          /*!< Read SFDP mode                                         */
#define FLASH_WRITE_ENABLE          0x06          /*!< Write enable                                           */
#define FLASH_WRITE_DISABLE         0x04          /*!< Write disable                                          */
#define FLASH_READ_STATUS           0x05          /*!< Read Status Register                                   */
#define FLASH_READ_CONFIGURATION    0x15          /*!< Read configuration register                            */
#define FLASH_WRITE_STATUS          0x01          /*!< Write status register                                  */
#define FLASH_SUSPEND_PROGRAM       0x75          /*!< Suspends erase                                         */
#define FLASH_SUSPEND_ERASE         0xB0          /*!< Suapends erase                                         */
#define FLASH_RESUMES_PROGRAM       0x7A          /*!< Resume program                                         */
#define FLASH_RESUMES_REASE         0x30          /*!< Resume erase                                           */
#define FLASH_DEEP_POWER_DOWN       0xB9          /*!< Deep power-down                                        */
#define FLASH_SET_BURST_LENGTH      0xC0          /*!< Burst read                                             */
#define FLASH_READ_IDENTIFICATION   0x9F          /*!< Read manufacturer ID + memory type + memory density.   */
#define FLASH_READ_ELECTRONIC_ID    0xAB          /*!< Read electronic ID.                                    */
#define FLASH_READ_REMS             0x90          /*!< Read manufacturer & device ID.                         */
#define FLASH_ENTER_SECURED_OTP     0xB1          /*!< Enter secured OTP                                      */
#define FLASH_EXIT_SECURED_OTP      0xC1          /*!< Exit secured OTP                                       */
#define FLASH_READ_SECURITY_REG     0x2B          /*!< Read security register                                 */
#define FLASH_WRITE_SECURITY_REG    0x2F          /*!< Write security register                                */
#define FLASH_NOP                   0x00          /*!< Nop                                                    */
#define FLASH_RESET_ENABLE          0x66          /*!< Reset enable                                           */
#define FLAHS_RESET_MEMORY          0x99          /*!< Reset memory                                           */

#define FLASH_SECTOR_ERASE          0x20          /*!< 1 sector = 4K bytes                                    */
#define FLASH_BLOCK32K_ERASE        0x52          /*!< Block erase 32K bytes                                  */
#define FLASH_BLOCK64K_ERASE        0xD8          /*!< Block erase 62K bytes                                  */
#define FLASH_CHIP_ERASE            0x60          /*!< Chip erase                                             */


/*The other */
#define FLASH_DUMMY_DATA            0xFFFFFFFF    /*!< Define dummy data */

#define FLASH_BUSY                  0x01
#define FLASH_NOBUSY                0x00



///@}


/** 
 * @name  typedef
 */                                                      
///@{


/*! @enum   Flash_ERASE_TypeDef
    @brief  The Flash Erase type.
*/
typedef enum
{
    FLASH_ERASE_SECTOR    = FLASH_SECTOR_ERASE,   /*!< Erase type = Sector(4K byte) erase.              */
    FLASH_ERASE_BLOCK32K  = FLASH_BLOCK32K_ERASE, /*!< Erase type = 32K byte block erase.               */
    FLASH_ERASE_BLOCK64K  = FLASH_BLOCK64K_ERASE, /*!< Erase type = 64K byte block erase.               */
    FLASH_ERASE_CHIP      = FLASH_CHIP_ERASE,     /*!< Erase type = Chip erase.                         */
}Flash_ERASE_TypeDef;



/*! @enum   Flash_Status_TypeDef
    @brief  Flash status type
*/
typedef enum
{
    Flash_Idle,
    Flash_CheckID,
    Flash_Erase,
    Flash_Programe,
    Flash_Read,
    Flash_Fail,
}Flash_Status_TypeDef;           


/*! @struct FlashCTR_TypeDef
    @brief  Flash data control.
*/ 
///@{
typedef struct 
{
    uint8_t               *pBuffer;                       /*!< Pointer of program data buffer.                   */
    uint8_t               *rBuffer;                       /*!< Pointer of recevie buffer.                        */
    uint32_t              Flash_RDID;                     /*!< Flash RDID.                                       */
    ctype                 Address;                        /*!< Control Flash address.                            */
    uint32_t              Total_Length;                   /*!< To control Flash read and write total address.    */
    uint32_t              BLen;                           /*!< To control Flash write bytes in a time.           */
    uint32_t              DataCnt;                        /*!< Use for Flash read and write operation parameter. */
    uint32_t              DMA_MaxSize;                    /*!< DMA Max size in once trigger                      */
    void                  (*DMATrigger)(uint32_t size );  /*!< DMA Trigger function for Flash                    */
    Flash_Status_TypeDef  Status;                         /*!< Flash status                                      */
    uint8_t               __padding[3];
    
}FlashCTR_TypeDef;


///@}

/** 
 * @name  variables
 */                                                      
///@{

extern FlashCTR_TypeDef  Flash0;

///@}

/** 
 * @name  function
 */                                                      
///@{

void BSP_Flash_Init(void);
void BSP_Flash_EraseFlash (Flash_ERASE_TypeDef EraseType , uint32_t Page_Num);
uint16_t BSP_Flash_ReadFlashRDCR (void);
void BSP_Flash_CheckFlashRDID(void);
void BPS_Flash_InputData(uint8_t DataLen , uint32_t FlashData);
uint8_t BSP_Flash_CheckFlashBusy (void);



///@}


#endif









